#!/bin/sh
INSPATH="/usr/local/spri"
BINPATH="/usr/local/sbin/spri"

if [ -d "$INSPATH" ]; then
        rm -rf $INSPATH
        mkdir $INSPATH
        cp -R files/* $INSPATH
        chmod 640 $INSPATH/*
        chmod 750 $INSPATH/spri
        ln -fs $INSPATH/spri $BINPATH
else
        mkdir $INSPATH
        cp -R files/* $INSPATH
        chmod 640 $INSPATH/*
        chmod 750 $INSPATH/spri
        ln -fs $INSPATH/spri $BINPATH
fi

if [ -f "/etc/cron.hourly/spri" ]; then
        rm -f /etc/cron.hourly/spri
fi

if [ -f "/etc/cron.d/spri" ]; then
        rm -f /etc/cron.d/spri
fi

if [ -f "cron" ]; then
        cp cron /etc/cron.d/spri
        chmod 644 /etc/cron.d/spri
fi

echo ".: SPRI installed"
echo "Install path:    $INSPATH"
echo "Config. path:    $INSPATH/conf.spri"
echo "Executable path: $BINPATH"
