#!/bin/sh
#
###############################################################################
# lfd
#
# Written by Jonathan Michaelson <jonathan@waytotheweb.com>
# A daemon that provides a method to track generic POP3 or IMAP logins and then
# email (in future:also block) the user if they exceed the number of accesses
# per given minutes allowed.
#
# Copyright 2006-2010 Way to the Web Limited (http://www.configserver.com)
###############################################################################
#
# chkconfig: 2345 80 30
# description: ConfigServer Firewall

[ -f /usr/sbin/csf ] || exit 0

# Source function library.
if [ -f /etc/init.d/functions ]; then
	. /etc/init.d/functions
fi

DAEMON=/usr/sbin/csf

if [ -f /etc/SuSE-release ]; then
	. /etc/rc.status
	rc_reset
fi

# See how we were called.
case "$1" in
  start)
	echo -n "Starting csf:"
	$DAEMON -s
	if [ -f /etc/SuSE-release ]; then
		rc_status -v
	elif [ -f /etc/debian_version ] || [ -f /etc/lsb-release ] || [ -f /etc/gentoo-release ]; then
		echo " Done"
	else
		success
		echo
	fi
	echo
	;;
  stop)
	echo -n "Stopping csf:"
	$DAEMON -f
	if [ -f /etc/SuSE-release ]; then
		rc_status -v
	elif [ -f /etc/debian_version ] || [ -f /etc/lsb-release ] || [ -f /etc/gentoo-release ]; then
		echo " Done"
	else
		success
		echo
	fi
	echo
	;;
  status)
        echo -n "Status of csf:"
	$DAEMON -l
	echo
        ;;
  restart)
	$0 stop
	$0 start
	;;
  *)
	echo "Usage: /etc/init.d/csf start|stop|restart|status"
	exit 1
esac

exit 0

