#!/usr/bin/perl
#WHMADDON:addonupdates:ConfigServer Security&<b>Firewall</b>
###############################################################################
# Copyright 2006-2010, Way to the Web Limited
# URL: http://www.configserver.com
# Email: sales@waytotheweb.com
###############################################################################
# start main

&loadconfig;

my $csfjs = <<EOF;
<script language="JavaScript">
var isNav4, isNav6, isIE4;
setBrowser();

function setBrowser()
{
    if (navigator.appVersion.charAt(0) == "4")
    {
        if (navigator.appName.indexOf("Explorer") >= 0)
        {
            isIE4 = true;
        }
        else
        {
            isNav4 = true;
        }
    }
    else if (navigator.appVersion.charAt(0) > "4")
    {
        isNav6 = true;
    }
}

function getStyleBySelector( selector )
{
    if (!isNav6)
    {
        return null;
    }
    var sheetList = document.styleSheets;
    var ruleList;
    var i, j;

    /* look through stylesheets in reverse order that
       they appear in the document */
    for (i=sheetList.length-1; i >= 0; i--)
    {
        ruleList = sheetList[i].cssRules;
        for (j=0; j<ruleList.length; j++)
        {
            if (ruleList[j].type == CSSRule.STYLE_RULE &&
                ruleList[j].selectorText == selector)
            {
                return ruleList[j].style;
            }   
        }
    }
    return null;
}

function getIdProperty( id, property )
{
    if (isNav6)
    {
        var styleObject = document.getElementById( id );
        if (styleObject != null)
        {
            styleObject = styleObject.style;
            if (styleObject[property])
            {
                return styleObject[ property ];
            }
        }
        styleObject = getStyleBySelector( "#" + id );
        return (styleObject != null) ?
            styleObject[property] :
            null;
    }
    else if (isNav4)
    {
        return document[id][property];
    }
    else
    {
        return document.all[id].style[property];
    }
}

function setIdProperty( id, property, value )
{
    if (isNav6)
    {
        var styleObject = document.getElementById( id );
        if (styleObject != null)
        {
            styleObject = styleObject.style;
            styleObject[ property ] = value;
        }
        
    }
    else if (isNav4)
    {
        document[id][property] = value;
    }
    else if (isIE4)
    {
         document.all[id].style[property] = value;
    }
}

function showMenu( divNum )
{
    if (getIdProperty( "s" + divNum, "display") != "block" )
    {
        setIdProperty("s" + divNum, "display", "block");
        document.images["i" + divNum].src = "$images/minus.png";
    }
    else
    {
        setIdProperty("s" + divNum, "display", "none");
        document.images["i" + divNum].src = "$images/plus.png";
    }
}

function expandO( ec ,totNum )
{
    for (j=1; j<totNum + 1; j++)
    {
            if (ec == "expand")
            {
                setIdProperty("s" + j, "display", "block");
                document.images["i" + j].src = "$images/minus.png";
            }
            else
            {
                setIdProperty("s" + j, "display", "none");
                document.images["i" + j].src = "$images/plus.png";
            }
    }
}
</script>
EOF

if ($FORM{action} eq "lfdstatus") {
	print "<p>Show lfd status...</p>\n<p><pre style='font-family: Courier New, Courier; font-size: 12px'>\n";
	&printcmd("/etc/init.d/lfd status");
	print "</p>\n<p>...<b>Done</b>.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "ms_list") {
	&modsec;
}
elsif ($FORM{action} eq "ms_config") {
	sysopen (IN, "/usr/local/apache/conf/$FORM{template}", O_RDWR | O_CREAT);
	flock (IN, LOCK_SH);
	my @confdata = <IN>;
	close (IN);
	chomp @confdata;

	print "<form action='$script' method='post'>\n";
	print "<input type='hidden' name='action' value='savems_config'>\n";
	print "<input type='hidden' name='template' value='$FORM{template}'>\n";
	print "<fieldset><legend><b>Edit $FORM{template}</b></legend>\n";
	print "<table style='border: 1px #990000 solid' align='center'>\n";
	print "<tr><td><textarea name='formdata' cols='80' rows='40' style='font-family: Courier New, Courier; font-size: 12px' wrap='off'>\n";
	foreach my $line (@confdata) {
		$line =~ s/\&/\&amp\;/g;
		$line =~ s/>/\&gt\;/g;
		$line =~ s/</\&lt\;/g;
		print $line."\n";
	}
	print "</textarea></td></tr></table></fieldset>\n";
	print "<p align='center'><input type='submit' value='Change'></p>\n";
	print "</form>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "savems_config") {
	$FORM{formdata} =~ s/\r//g;
	sysopen (OUT, "/usr/local/apache/conf/$FORM{template}", O_WRONLY | O_CREAT);
	flock (OUT, LOCK_EX);
	seek (OUT, 0, 0);
	truncate (OUT, 0);
	if ($FORM{formdata} !~ /\n$/) {$FORM{formdata} .= "\n"}
	print OUT $FORM{formdata};
	close (OUT);

	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
	print "<tr><th align='left'>ModSecurity save $FORM{template}</th></tr>";
	print "<tr bgcolor='#F4F4EA'><td>You should restart Apache having changed this file</td></tr>\n";
	print "</table>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "lfdstart") {
	print "<p>Starting lfd...</p>\n<p><pre style='font-family: Courier New, Courier; font-size: 12px'>\n";
	&printcmd("/etc/init.d/lfd start");
	print "</p>\n<p>...<b>Done</b>.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "lfdrestart") {
	if ($config{DIRECTADMIN}) {
		print "<p>Signal lfd to <i>restart</i>...</p>\n<p><pre style='font-family: Courier New, Courier; font-size: 12px'>\n";
		sysopen (OUT, "/etc/csf/lfd.restart",, O_WRONLY | O_CREAT);
		close (OUT);
	} else {
		print "<p>Restarting lfd...</p>\n<p><pre style='font-family: Courier New, Courier; font-size: 12px'>\n";
		&printcmd("/etc/init.d/lfd restart");
	}
	print "</p>\n<p>...<b>Done</b>.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "lfdstop") {
	print "<p>Stopping lfd...</p>\n<p><pre style='font-family: Courier New, Courier; font-size: 12px'>\n";
	&printcmd("/etc/init.d/lfd stop");
	print "</p>\n<p>...<b>Done</b>.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "status") {
	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='FFFFFF' style='border:1px solid #990000'>\n";
	print "<tr><td><pre style='font-family: Courier New, Courier; font-size: 12px'>\n";
	&printcmd("perl /etc/csf/csf.pl -l");
	print "</pre></td></tr></table>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "start") {
	print "<p>Starting csf...</p>\n<p><pre style='font-family: Courier New, Courier; font-size: 12px'>\n";
	&printcmd("perl /etc/csf/csf.pl -s");
	print "</p>\n<p>...<b>Done</b>.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "restart") {
	print "<p>Restarting csf...</p>\n<p><pre style='font-family: Courier New, Courier; font-size: 12px'>\n";
	&printcmd("perl /etc/csf/csf.pl -r");
	print "</p>\n<p>...<b>Done</b>.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "temp") {
	if (! -z "/etc/csf/csf.tempban") {
		open (IN, "</etc/csf/csf.tempban") or die $!;
		my @data = <IN>;
		chomp @data;
		close (IN);

		my $class = '#F4F4EA';
		print "<table align='center' border='0' cellspacing='0' cellpadding='4' bgcolor='FFFFFF' style='border:1px solid #990000'\n";
		print "<tr><th>&nbsp;</th><th>IP address</th><th>Port</th><th>Dir</th><th>TTL (secs)</th><th>Comment</th></tr>\n";
		foreach my $line (@data) {
			if ($line eq "") {next}
			my ($time,$ip,$port,$inout,$timeout,$message) = split(/:/,$line);
			$time = $timeout - (time - $time);
			if ($port eq "") {$port = "*"}
			if ($inout eq "") {$inout = " *"}
			if ($time < 1) {$time = "<1"}
			print "<tr bgcolor='$class'><td>&nbsp;<a href='$script?action=temprm&ip=$ip'><img src='$images/delete.png' border='0' alt='Unblock $ip?'></a>&nbsp;</td><td>$ip</td><td>$port</td><td>$inout</td><td>$time</td><td>$message</td></tr>\n";
			if ($class eq '#FFFFFF') {$class = '#F4F4EA'} else {$class = '#FFFFFF'}
		}
		print "</table>\n";
		print "<p align='center'>Flush all temporary IP blocks <a href='$script?action=temprm&ip=all'><img src='$images/delete.png' border='0' alt='Unblock All IPs?' valign='middle'></a></p>\n";
	} else {
		print "csf: There are no temporary IP bans\n";
	}
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "temprm") {
	print "<p>Removing temporary ban for $FORM{ip}:</p>\n<p><pre style='font-family: Courier New, Courier; font-size: 12px'>\n";
	if ($FORM{ip} eq "all") {
		&printcmd("perl /etc/csf/csf.pl -tf");
	} else {
		&printcmd("perl /etc/csf/csf.pl -tr $FORM{ip}");
	}
	print "</p>\n<p>...<b>Done</b>.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='action' value='temp'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "tempdeny") {
	print "<p>Temporarily blocking $FORM{ip} for $FORM{timeout} seconds:</p>\n<p><pre style='font-family: Courier New, Courier; font-size: 12px'>\n";
	&printcmd("perl /etc/csf/csf.pl -td $FORM{ip} $FORM{timeout}");
	print "</p>\n<p>...<b>Done</b>.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "stop") {
	print "<p>Stopping csf...</p>\n<p><pre style='font-family: Courier New, Courier; font-size: 12px'>\n";
	&printcmd("perl /etc/csf/csf.pl -f");
	print "</p>\n<p>...<b>Done</b>.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "disable") {
	print "<p>Disabling csf...</p>\n<p><pre style='font-family: Courier New, Courier; font-size: 12px'>\n";
	&printcmd("perl /etc/csf/csf.pl -x");
	print "</p>\n<p>...<b>Done</b>.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "enable") {
	if ($config{DIRECTADMIN}) {
		print "<p>Due to restrictions in DirectAdmin you must login to the root shell to enable csf using:\n<p><b>csf -e</b>\n";
	} else {
		print "<p>Enabling csf...</p>\n<p><pre style='font-family: Courier New, Courier; font-size: 12px'>\n";
		&printcmd("perl /etc/csf/csf.pl -e");
	}
	print "</p>\n<p>...<b>Done</b>.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "tail") {
	print "<p>Displaying the last $FORM{lines} lines of /var/log/lfd.log...</p>\n<p><pre style='font-family: Courier New, Courier; font-size: 12px'>\n";
	&printcmd("tail -$FORM{lines} /var/log/lfd.log");
	print "</pre></p>\n";
	if ($FORM{refresh}) {
print <<EOF;
<script language="JavaScript">

//Refresh page script- By Brett Taylor (glutnix\@yahoo.com.au)
//Modified by Dynamic Drive for NS4, NS6+
//Visit http://www.dynamicdrive.com for this script

//configure refresh interval (in seconds)
var countDownInterval=5;
//configure width of displayed text, in px (applicable only in NS4)
var c_reloadwidth=200
var page_url = "$script?action=tail&lines=$FORM{lines}&refresh=$FORM{refresh}";
</script>


<ilayer id="c_reload" width=&{c_reloadwidth}; ><layer id="c_reload2" width=&{c_reloadwidth}; left=0 top=0></layer></ilayer>

<script>

var countDownTime=countDownInterval+1;
function countDown(){
countDownTime--;
if (countDownTime <0){
countDownTime=countDownInterval;
clearTimeout(counter);
window.location.href=page_url;
return
}
if (document.all) //if IE 4+
document.all.countDownText.innerText = countDownTime+" ";
else if (document.getElementById) //else if NS6+
document.getElementById("countDownText").innerHTML=countDownTime+" "
else if (document.layers){ //CHANGE TEXT BELOW TO YOUR OWN
document.c_reload.document.c_reload2.document.write('This page will <b><u><a href="javascript:window.location.href=page_url">refresh</a></u></b> in <b id="countDownText">'+countDownTime+' </b> seconds')
document.c_reload.document.c_reload2.document.close()
}
counter=setTimeout("countDown()", 1000);
}

function startit(){
if (document.all||document.getElementById) //CHANGE TEXT BELOW TO YOUR OWN
document.write('This page will <b><u><a href="javascript:window.location.href=page_url">refresh</a></u></b> in <b id="countDownText">'+countDownTime+' </b> seconds')
countDown()
}

if (document.all||document.getElementById)
startit()
else
window.onload=startit

</script>
EOF
	}
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "readme") {
	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='FFFFFF' style='border:1px solid #990000'>\n";
	print "<tr><td><pre style='font-family: Courier New, Courier; font-size: 12px'>\n";
	open (IN, "</etc/csf/readme.txt") or die $!;
	my @readme = <IN>;
	close (IN);
	chomp @readme;

	foreach my $line (@readme) {
		$line =~ s/\</\&lt\;/g;
		$line =~ s/\>/\&gt\;/g;
		print $line."\n";
	}
	print "</pre></td></tr></table>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "servercheck") {
	do "/etc/csf/servercheck.pm";

	open (IN, "</etc/cron.d/csfcron.sh");
	flock (IN, LOCK_SH);
	my @data = <IN>;
	close (IN);
	chomp @data;
	my $optionselected = "never";
	my $email;
	if (my @ls = grep {$_ =~ /csf \-m/} @data) {
		if ($ls[0] =~ /\@(\w+)\s+root\s+\/usr\/sbin\/csf -m (.*)/) {$optionselected = $1; $email = $2}
	}
	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='action' value='serverchecksave'>\n";
	print "Generate and email this report <select name='freq'>\n";
	foreach my $option ("never","hourly","daily","weekly","monthly") {
		if ($option eq $optionselected) {print "<option selected>$option</option>\n"} else {print "<option>$option</option>\n"}
	}
	print "</select> to the email address <input type='text' name='email' value='$email'> <input type='submit' value='Schedule'></form>";

	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='action' value='servercheck'><input type='hidden' name='verbose' value='1'><input type='submit' value='Run Again and Display All Comments'></form>";
	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='action' value='servercheck'><input type='submit' value='Run Again'></form>";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "serverchecksave") {
	my $extra = "";
	unless ($FORM{email}) {$FORM{freq} = "never"; $extra = "(no email address supplied)";}
	sysopen (CRON, "/etc/cron.d/csfcron.sh", O_RDWR | O_CREAT);
	flock (CRON, LOCK_EX);
	my @data = <CRON>;
	chomp @data;
	seek (CRON, 0, 0);
	truncate (CRON, 0);
	my $done = 0;
	foreach my $line (@data) {
		if ($line =~ /csf \-m/) {
			if ($FORM{freq} and ($FORM{freq} ne "never") and !$done) {
				print CRON "\@$FORM{freq} root /usr/sbin/csf -m $FORM{email}\n";
				$done = 1;
			}
		} else {
			print CRON "$line\n";
		}
	}
	if (!$done and ($FORM{freq} ne "never")) {
			print CRON "\@$FORM{freq} root /usr/sbin/csf -m $FORM{email}\n";
	}
	close (CRON);

	if ($FORM{freq} and $FORM{freq} ne "never") {
		print "<p>Report scheduled to be emailed to $FORM{email} $FORM{freq}\n";
	} else {
		print "<p>Report schedule cancelled $extra\n";
	}
	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='action' value='servercheck'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "restartboth") {
	print "<p>Restarting csf...</p>\n<p><pre style='font-family: Courier New, Courier; font-size: 12px'>\n";
	&printcmd("perl /etc/csf/csf.pl -r");
	print "</p>\n<p>...<b>Done</b>.</p>\n";
	if ($config{DIRECTADMIN}) {
		print "<p>Signal lfd to <i>restart</i>...</p>\n<p><pre style='font-family: Courier New, Courier; font-size: 12px'>\n";
		sysopen (OUT, "/etc/csf/lfd.restart",, O_WRONLY | O_CREAT);
		close (OUT);
	} else {
		print "<p>Restarting lfd...</p>\n<p><pre style='font-family: Courier New, Courier; font-size: 12px'>\n";
		&printcmd("/etc/init.d/lfd restart");
	}
	print "</p>\n<p>...<b>Done</b>.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "remapf") {
	print "<p>Removing APF/BFD...</p>\n<p><pre style='font-family: Courier New, Courier; font-size: 12px'>\n";
	&printcmd("sh /etc/csf/remove_apf_bfd.sh");
	print "</p>\n<p>...<b>Done</b>.</p>\n";
	print "<p><b>Note: You should check the root cron and /etc/crontab to ensure that there are no apf or bfd related cron jobs remaining</b></p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "qallow") {
	print "<p>Allowing $FORM{ip}...</p>\n<p><pre style='font-family: Courier New, Courier; font-size: 12px'>\n";
	&printcmd("perl /etc/csf/csf.pl -a $FORM{ip}");
	print "</p>\n<p>...<b>Done</b>.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='mobi' value='$FORM{mobi}'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "qdeny") {
	print "<p>Blocking $FORM{ip}...</p>\n<p><pre style='font-family: Courier New, Courier; font-size: 12px'>\n";
	&printcmd("perl /etc/csf/csf.pl -d $FORM{ip}");
	print "</p>\n<p>...<b>Done</b>.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='mobi' value='$FORM{mobi}'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "kill") {
	print "<p>Remove $FORM{ip}...</p>\n<p><pre style='font-family: Courier New, Courier; font-size: 12px'>\n";
	&printcmd("perl /etc/csf/csf.pl -dr $FORM{ip}");
	print "</p>\n<p>...<b>Done</b>.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='mobi' value='$FORM{mobi}'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "grep") {
	print "<p>Searching for $FORM{ip}...</p>\n<p><pre style='font-family: Courier New, Courier; font-size: 12px'>\n";
	&printcmd("perl /etc/csf/csf.pl -g $FORM{ip}");
	print "</p>\n<p>...<b>Done</b>.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "allow") {
	sysopen (IN, "/etc/csf/csf.allow", O_RDWR | O_CREAT);
	flock (IN, LOCK_SH);
	my @confdata = <IN>;
	close (IN);
	chomp @confdata;
	my $max = 80;
	foreach my $line (@confdata) {if (length($line) > $max) {$max = length($line) + 1}}

	print "<form action='$script' method='post'>\n";
	print "<input type='hidden' name='action' value='saveallow'>\n";
	print "<fieldset><legend><b>Edit csf.allow</b></legend>\n";
	print "<table style='border: 1px #990000 solid' align='center'>\n";
	print "<tr><td><textarea name='formdata' cols='$max' rows='40' style='font-family: Courier New, Courier; font-size: 12px'>\n";
	foreach my $line (@confdata) {
		$line =~ s/\</\&lt\;/g;
		$line =~ s/\>/\&gt\;/g;
		print $line."\n";
	}
	print "</textarea></td></tr></table></fieldset>\n";
	print "<p align='center'><input type='submit' value='Change'></p>\n";
	print "</form>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "saveallow") {
	$FORM{formdata} =~ s/\r//g;
	sysopen (OUT, "/etc/csf/csf.allow", O_WRONLY | O_CREAT);
	flock (OUT, LOCK_EX);
	seek (OUT, 0, 0);
	truncate (OUT, 0);
	if ($FORM{formdata} !~ /\n$/) {$FORM{formdata} .= "\n"}
	print OUT $FORM{formdata};
	close (OUT);

	print "<p>Changes saved. You should restart csf and lfd.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='action' value='restartboth'><input type='submit' value='Restart csf+lfd'></form></p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "dirwatch") {
	sysopen (IN, "/etc/csf/csf.dirwatch", O_RDWR | O_CREAT);
	flock (IN, LOCK_SH);
	my @confdata = <IN>;
	close (IN);
	chomp @confdata;
	my $max = 80;
	foreach my $line (@confdata) {if (length($line) > $max) {$max = length($line) + 1}}

	print "<form action='$script' method='post'>\n";
	print "<input type='hidden' name='action' value='savedirwatch'>\n";
	print "<fieldset><legend><b>Edit csf.dirwatch</b></legend>\n";
	print "<table style='border: 1px #990000 solid' align='center'>\n";
	print "<tr><td><textarea name='formdata' cols='$max' rows='40' style='font-family: Courier New, Courier; font-size: 12px'>\n";
	foreach my $line (@confdata) {
		$line =~ s/\</\&lt\;/g;
		$line =~ s/\>/\&gt\;/g;
		print $line."\n";
	}
	print "</textarea></td></tr></table></fieldset>\n";
	print "<p align='center'><input type='submit' value='Change'></p>\n";
	print "</form>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "savedirwatch") {
	$FORM{formdata} =~ s/\r//g;
	sysopen (OUT, "/etc/csf/csf.dirwatch", O_WRONLY | O_CREAT);
	flock (OUT, LOCK_EX);
	seek (OUT, 0, 0);
	truncate (OUT, 0);
	if ($FORM{formdata} !~ /\n$/) {$FORM{formdata} .= "\n"}
	print OUT $FORM{formdata};
	close (OUT);

	print "<p>Changes saved. You should restart lfd.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='action' value='lfdrestart'><input type='submit' value='Restart lfd'></form></p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "dyndns") {
	sysopen (IN, "/etc/csf/csf.dyndns", O_RDWR | O_CREAT);
	flock (IN, LOCK_SH);
	my @confdata = <IN>;
	close (IN);
	chomp @confdata;
	my $max = 80;
	foreach my $line (@confdata) {if (length($line) > $max) {$max = length($line) + 1}}

	print "<form action='$script' method='post'>\n";
	print "<input type='hidden' name='action' value='savedyndns'>\n";
	print "<fieldset><legend><b>Edit csf.dyndns</b></legend>\n";
	print "<table style='border: 1px #990000 solid' align='center'>\n";
	print "<tr><td><textarea name='formdata' cols='$max' rows='40' style='font-family: Courier New, Courier; font-size: 12px'>\n";
	foreach my $line (@confdata) {
		$line =~ s/\</\&lt\;/g;
		$line =~ s/\>/\&gt\;/g;
		print $line."\n";
	}
	print "</textarea></td></tr></table></fieldset>\n";
	print "<p align='center'><input type='submit' value='Change'></p>\n";
	print "</form>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "savedyndns") {
	$FORM{formdata} =~ s/\r//g;
	sysopen (OUT, "/etc/csf/csf.dyndns", O_WRONLY | O_CREAT);
	flock (OUT, LOCK_EX);
	seek (OUT, 0, 0);
	truncate (OUT, 0);
	if ($FORM{formdata} !~ /\n$/) {$FORM{formdata} .= "\n"}
	print OUT $FORM{formdata};
	close (OUT);

	print "<p>Changes saved. You should restart lfd.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='action' value='lfdrestart'><input type='submit' value='Restart lfd'></form></p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "deny") {
	sysopen (IN, "/etc/csf/csf.deny", O_RDWR | O_CREAT);
	flock (IN, LOCK_SH);
	my @confdata = <IN>;
	close (IN);
	chomp @confdata;
	my $max = 80;
	foreach my $line (@confdata) {if (length($line) > $max) {$max = length($line) + 1}}

	print "<form action='$script' method='post'>\n";
	print "<input type='hidden' name='action' value='savedeny'>\n";
	print "<fieldset><legend><b>Edit csf.deny</b></legend>\n";
	print "<table style='border: 1px #990000 solid' align='center'>\n";
	print "<tr><td><textarea name='formdata' cols='$max' rows='40' style='font-family: Courier New, Courier; font-size: 12px'>\n";
	foreach my $line (@confdata) {
		$line =~ s/\</\&lt\;/g;
		$line =~ s/\>/\&gt\;/g;
		print $line."\n";
	}
	print "</textarea></td></tr></table></fieldset>\n";
	print "<p align='center'><input type='submit' value='Change'></p>\n";
	print "</form>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "savedeny") {
	$FORM{formdata} =~ s/\r//g;
	sysopen (OUT, "/etc/csf/csf.deny", O_WRONLY | O_CREAT);
	flock (OUT, LOCK_EX);
	seek (OUT, 0, 0);
	truncate (OUT, 0);
	if ($FORM{formdata} !~ /\n$/) {$FORM{formdata} .= "\n"}
	print OUT $FORM{formdata};
	close (OUT);

	print "<p>Changes saved. You should restart csf and lfd.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='action' value='restartboth'><input type='submit' value='Restart csf+lfd'></form></p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "templates") {
	sysopen (IN, "/etc/csf/$FORM{template}", O_RDWR | O_CREAT);
	flock (IN, LOCK_SH);
	my @confdata = <IN>;
	close (IN);
	chomp @confdata;
	my $max = 80;
	foreach my $line (@confdata) {if (length($line) > $max) {$max = length($line) + 1}}

	print "<form action='$script' method='post'>\n";
	print "<input type='hidden' name='action' value='savetemplates'>\n";
	print "<input type='hidden' name='template' value='$FORM{template}'>\n";
	print "<fieldset><legend><b>Edit $FORM{template}</b></legend>\n";
	print "<table style='border: 1px #990000 solid' align='center'>\n";
	print "<tr><td><textarea name='formdata' cols='$max' rows='40' style='font-family: Courier New, Courier; font-size: 12px' wrap='off'>\n";
	foreach my $line (@confdata) {
		$line =~ s/\</\&lt\;/g;
		$line =~ s/\>/\&gt\;/g;
		print $line."\n";
	}
	print "</textarea></td></tr></table></fieldset>\n";
	print "<p align='center'><input type='submit' value='Change'></p>\n";
	print "</form>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "savetemplates") {
	$FORM{formdata} =~ s/\r//g;
	sysopen (OUT, "/etc/csf/$FORM{template}", O_WRONLY | O_CREAT);
	flock (OUT, LOCK_EX);
	seek (OUT, 0, 0);
	truncate (OUT, 0);
	if ($FORM{formdata} !~ /\n$/) {$FORM{formdata} .= "\n"}
	print OUT $FORM{formdata};
	close (OUT);

	print "<p>Changes saved.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "ignorefiles") {
	sysopen (IN, "/etc/csf/$FORM{ignorefile}", O_RDWR | O_CREAT);
	flock (IN, LOCK_SH);
	my @confdata = <IN>;
	close (IN);
	chomp @confdata;
	my $max = 80;
	foreach my $line (@confdata) {if (length($line) > $max) {$max = length($line) + 1}}

	print "<form action='$script' method='post'>\n";
	print "<input type='hidden' name='action' value='saveignorefiles'>\n";
	print "<input type='hidden' name='ignorefile' value='$FORM{ignorefile}'>\n";
	print "<fieldset><legend><b>Edit $FORM{ignorefile}</b></legend>\n";
	print "<table style='border: 1px #990000 solid' align='center'>\n";
	print "<tr><td><textarea name='formdata' cols='$max' rows='40' style='font-family: Courier New, Courier; font-size: 12px' wrap='off'>\n";
	foreach my $line (@confdata) {
		$line =~ s/\</\&lt\;/g;
		$line =~ s/\>/\&gt\;/g;
		print $line."\n";
	}
	print "</textarea></td></tr></table></fieldset>\n";
	print "<p align='center'><input type='submit' value='Change'></p>\n";
	print "</form>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "saveignorefiles") {
	$FORM{formdata} =~ s/\r//g;
	sysopen (OUT, "/etc/csf/$FORM{ignorefile}", O_WRONLY | O_CREAT);
	flock (OUT, LOCK_EX);
	seek (OUT, 0, 0);
	truncate (OUT, 0);
	if ($FORM{formdata} !~ /\n$/) {$FORM{formdata} .= "\n"}
	print OUT $FORM{formdata};
	close (OUT);

	print "<p>Changes saved. You should restart lfd.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='action' value='lfdrestart'><input type='submit' value='Restart lfd'></form></p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "conf") {
	sysopen (IN, "/etc/csf/csf.conf", O_RDWR | O_CREAT);
	flock (IN, LOCK_SH);
	my @confdata = <IN>;
	close (IN);
	chomp @confdata;

	print "<fieldset><legend><b>Edit ConfigServer Firewall</b></legend>\n";
	print "<form action='$script' method='post'>\n";
	print "<input type='hidden' name='action' value='saveconf'>\n";
	print "<table align='center' style='background: white; border: 1px #990000 solid; color:black'>\n";
	foreach my $line (@confdata) {
		if (($line !~ /^\#/) and ($line =~ /=/)) {
			my ($start,$end) = split (/=/,$line);
			my $name = $start;
			$name =~ s/\s/\_/g;
			if ($end =~ /\"(.*)\"/) {$end = $1}
			my $size = length($end) + 4;
			my $bgcolor = "white";
			my ($status,$range,$default) = &sanity($start,$end);
			my $showrange = "";
			if ($default ne "") {
				$showrange = " Default: $default";
				if ($end ne $default) {$bgcolor = "#F4F4EA"}
			}
			if ($status) {$bgcolor = "red"; $showrange = " Recommended range: $range (Default: $default)"}
			print "<tr><td style='font-family: Courier New, Courier; font-size: 12px' bgcolor='$bgcolor'><b>$start</b> = <input type='text' name='$name' value='$end' size='$size'>$showrange</td></tr>\n";
		} else {
			$line =~ s/</&lt;/g;
			$line =~ s/>/&gt;/g;
			$line =~ s/\n/<br>\n/g;
			print "<tr><td>$line</td></tr>\n";
		}
	}
	print "</table></fieldset>\n";
	print "<p align='center'><input type='submit' value='Change'></p>\n";
	print "</form>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "saveconf") {
	sysopen (IN, "/etc/csf/csf.conf", O_RDWR | O_CREAT);
	flock (IN, LOCK_SH);
	my @confdata = <IN>;
	close (IN);
	chomp @confdata;

	sysopen (OUT, "/etc/csf/csf.conf", O_WRONLY | O_CREAT);
	flock (OUT, LOCK_EX);
	seek (OUT, 0, 0);
	truncate (OUT, 0);
	for (my $x = 0; $x < @confdata;$x++) {
		if (($confdata[$x] !~ /^\#/) and ($confdata[$x] =~ /=/)) {
			my ($start,$end) = split (/=/,$confdata[$x]);
			my $name = $start;
			my $sanity_name = $start;
			$name =~ s/\s/\_/g;
			$sanity_name =~ s/\s//g;
			print OUT "$start= \"$FORM{$name}\"\n";
			my ($status,$range, $default) = &sanity($sanity_name,$FORM{$name});
			if ($status) {print "<br>WARNING: $sanity_name sanity check. $sanity_name = $FORM{$name}. Recommended range: $range (Default: $default)\n"}
		} else {
			print OUT "$confdata[$x]\n";
		}
	}
	close (OUT);

	print "<p>Changes saved. You should restart both csf and lfd.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='action' value='restartboth'><input type='submit' value='Restart csf+lfd'></form></p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "viewlogs") {
	if (-e "/etc/csf/stats/iptables_log") {
		sysopen (IN, "/etc/csf/stats/iptables_log", O_RDWR | O_CREAT);
		flock (IN, LOCK_SH);
		my @iptables = <IN>;
		close (IN);
		chomp @iptables;
		@iptables = reverse @iptables;
		my $from;
		my $to;
		my $divcnt = 0;
		my $expcnt = @iptables;
		my $class = '#F4F4EA';

		if ($iptables[0] =~ /\|(\S+\s+\d+\s+\S+)/) {$from = $1}
		if ($iptables[-1] =~ /\|(\S+\s+\d+\s+\S+)/) {$to = $1}

		print "<p align='center'><big>Last $config{ST_IPTABLES} iptables logs*, latest:<b>$from</b> oldest:<b>$to</b></big></p>\n";

		print "<style type='text/css'>\n<!--\n.submenu {\n    display:none;\n}\n.mhead {\n    display: block;\n}\n-->\n</style>\n$csfjs\n";
		print "<br><table align='center' cellpadding='4' cellspacing='1' width='95%' align='center' bgcolor='#990000'>\n";
		print "<tr bgcolor='#F4F4EA'><td colspan='7'>";
		print " <a href='javascript:expandO(\"expand\",$expcnt);'><img valign='absmiddle' src='$images/plus.png' name='i$divcnt' border='0' width='12' height='12'>Expand All</a>\n";
		print " <a href='javascript:expandO(\"collapse\",$expcnt);'><img valign='absmiddle' src='$images/minus.png' name='i$divcnt' border='0' width='12' height='12'>Collapse All</a>\n";
		print "</td></tr>\n";
		print "<tr bgcolor='#FFFFFF'><td><b>Time</b></td><td width='50%'><b>From</b></td><td><b>Port</b></td><td><b>I/O</b></td><td width='50%'><b>To</b></td><td><b>Port</b></td><td><b>Proto</b></td></tr>\n";
		foreach my $line (@iptables) {
			$divcnt++;
			my ($text,$log) = split(/\|/,$line);
			my ($time,$desc,$in,$out,$src,$dst,$spt,$dpt,$proto,$inout);
			if ($log =~ /IN=([a-zA-Z0-9:_])?/) {$in = $1}
			if ($log =~ /OUT=([a-zA-Z0-9:_])?/) {$out = $1}
			if ($log =~ /SRC=(\d+\.\d+\.\d+\.\d+)/) {$src = $1}
			if ($log =~ /DST=(\d+\.\d+\.\d+\.\d+)/) {$dst = $1}
			if ($log =~ /SPT=(\d+)/) {$spt = $1}
			if ($log =~ /DPT=(\d+)/) {$dpt = $1}
			if ($log =~ /PROTO=([A-Z]+)/) {$proto = $1}

			if ($text ne "") {
				$text =~ s/\(/\<br\>\(/g;
				if ($in and $src) {$src = $text ; $dst .= " <br>(server)"}
				elsif ($out and $dst) {$dst = $text ; $src .= " <br>(server)"}
			}
			if ($log =~ /^(\S+\s+\d+\s+\S+)/) {$time = $1}

			$inout = "n/a";
			if ($in) {$inout = "in"}
			elsif ($out) {$inout = "out"}

			print "<tr bgcolor='$class'><td nowrap><a href='javascript:showMenu($divcnt);'><img valign='absmiddle' src='$images/plus.png' name='i$divcnt' border='0' width='12' height='12'></a> $time</td><td>$src</td><td>$spt</td><td>$inout</td><td>$dst</td><td>$dpt</td><td>$proto</td></tr>\n";

			$log =~ s/\&/\&amp\;/g;
			$log =~ s/>/\&gt\;/g;
			$log =~ s/</\&lt\;/g;
			print "<tr bgcolor='$class'><td colspan='7'><span class='submenu' id='s$divcnt'>$log</span></td></tr>\n";
			if ($class eq '#FFFFFF') {$class = '#F4F4EA'} else {$class = '#FFFFFF'}
		}
		print "</table>\n";
		print "<p>* These iptables logs taken from $config{IPTABLES_LOG} will not necessarily show all packets blocked by iptables. For example, ports listed in DROP_NOLOG or the settings for DROP_LOGGING/DROP_IP_LOGGING/DROP_ONLYRES/DROP_PF_LOGGING will affect what is logged. Additionally, there is rate limiting on all iptables log rules to prevent log file flooding</p>\n";
	} else {
		print "<p> No logs entries found<p>\n";
	}

	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "sips") {
	sysopen (IN, "/etc/csf/csf.sips", O_RDWR | O_CREAT);
	flock (IN, LOCK_SH);
	my @confdata = <IN>;
	close (IN);
	chomp @confdata;

	print "<form action='addon_csf.cgi' method='post'><input type='hidden' name='action' value='sipsave'><br>\n";
	print "<table align='center' border='0' cellspacing='0' cellpadding='4' bgcolor='FFFFFF' style='border:1px solid #990000'\n";
	print "<tr bgcolor='#FFFFFF'><td><b>IP Address</b></td><td><b>Deny All Access to IP</b></td></tr>\n";
	my $class = '#F4F4EA';

	my %sips;
	my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/csf/csf.sips");
	my @data = <IN>;
	Cpanel::SafeFile::safeclose(\*IN,$inlock);
	chomp @data;
	foreach my $line (@data) {
		if ($line =~ /^\d+\.\d+\.\d+\.\d+$/) {$sips{$line} = 1}
	}

	my ($childin, $childout);
	my $pid = open3($childin, $childout, $childout, $config{IFCONFIG});
	my @ifconfig = <$childout>;
	waitpid ($pid, 0);
	chomp @ifconfig;

	foreach my $line (@ifconfig) {
		if ($line =~ /inet \w*:(\d+\.\d+\.\d+\.\d+)/) {
			my $ip = $1;
			if ($ip =~ /^127\.0\.0/) {next}
			my $chk = "ip_$ip";
			$chk =~ s/\./\_/g;
			my $checked = "";
			if ($sips{$ip}) {$checked = "checked"}
			print "<tr bgcolor='$class'><td>$ip</td><td align='center'><input type='checkbox' name='$chk' $checked></td></tr>\n";
			if ($class eq '#FFFFFF') {$class = '#F4F4EA'} else {$class = '#FFFFFF'}
		}
	}

	print "<tr bgcolor='$class'><td colspan='3' align='center'><input type='submit' value='Change'></td></tr>\n";
	print "</table></form>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "sipsave") {
	my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/csf/csf.sips");
	my @data = <IN>;
	Cpanel::SafeFile::safeclose(\*IN,$inlock);
	chomp @data;

	$inlock = Cpanel::SafeFile::safeopen(\*OUT,">","/etc/csf/csf.sips");
	foreach my $line (@data) {
		if ($line =~ /^\#/) {print OUT "$line\n"} else {last}
	}
	foreach my $key (keys %FORM) {
		if ($key =~ /^ip_(.*)/) {
			my $ip = $1;
			$ip =~ s/\_/\./g;
			print OUT "$ip\n";
		}
	}
	Cpanel::SafeFile::safeclose(\*OUT,$inlock);

	print "<p>Changes saved. You should restart csf.</p>\n";
	print "<p align='center'><form action='addon_csf.cgi' method='post'><input type='hidden' name='action' value='restart'><input type='submit' value='Restart csf'></form></p>\n";
	print "<p align='center'><form action='addon_csf.cgi' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "quick") {
	print "<form action='$script' method='post'><input type='hidden' name='action' value='quicksave'><br>\n";

	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
	print "<tr bgcolor='#F4F4EA'><th align='left'>Firewall Security Level</th></tr><tr><td align='left'><table width='100%' cellpadding='4' cellspacing='0' align='center' bgcolor='FFFFFF' style='border:1px solid #990000'\n";

	print "<tr bgcolor='#FFFFFF'><td><b>Setting</b> (see the Firewall Configuration for more information)</td><td align='center'><b>Current</b></td><td align='center'><b>Low</b></td><td align='center'><b>Medium</b></td><td align='center'><b>High</b></td></tr>\n";
	print "<tr bgcolor='#F4F4EA'><td>Block outgoing SMTP connections except for root, exim and mailman</td><td align='center'><b>$config{SMTP_BLOCK}</b></td><td align='center'>0</td><td align='center'>1</td><td align='center'>1</td></tr>\n";
	print "<tr bgcolor='#FFFFFF'><td>Allow outgoing SMTP connections from localhost (127.0.0.1)</td><td align='center'><b>$config{SMTP_ALLOWLOCAL}</b></td><td align='center'>1</td><td align='center'>1</td><td align='center'>0</td></tr>\n";
	print "<tr bgcolor='#F4F4EA'><td>Enable IP range blocking using the DShield Block List</td><td align='center'><b>$config{LF_DSHIELD}</b></td><td align='center'>0</td><td align='center'>86400</td><td align='center'>86400</td></tr>\n";
	print "<tr bgcolor='#FFFFFF'><td>Enable IP range blocking using the Spamhaus DROP List</td><td align='center'><b>$config{LF_SPAMHAUS}</b></td><td align='center'>0</td><td align='center'>86400</td><td align='center'>86400</td></tr>\n";
	print "<tr bgcolor='#F4F4EA'><td>Enable Connection Tracking</td><td align='center'><b>$config{CT_LIMIT}</b></td><td align='center'>0</td><td align='center'>400</td><td align='center'>300</td></tr>\n";
	print "<tr bgcolor='#FFFFFF'><td>Permanently block Connection Tracking triggered IPs</td><td align='center'><b>$config{CT_PERMANENT}</b></td><td align='center'>0</td><td align='center'>0</td><td align='center'>1</td></tr>\n";
	print "<tr bgcolor='#F4F4EA'><td>Enable Directory Watching</td><td align='center'><b>$config{LF_DIRWATCH}</b></td><td align='center'>300</td><td align='center'>120</td><td align='center'>60</td></tr>\n";
	print "<tr bgcolor='#FFFFFF'><td>Remove suspicious files</td><td align='center'><b>$config{LF_DIRWATCH_DISABLE}</b></td><td align='center'>0</td><td align='center'>1</td><td align='center'>1</td></tr>\n";
	print "<tr bgcolor='#F4F4EA'><td>Enable Process Tracking</td><td align='center'><b>$config{PT_LIMIT}</b></td><td align='center'>60</td><td align='center'>60</td><td align='center'>30</td></tr>\n";
	print "<tr bgcolor='#FFFFFF'><td>Enable User Process Tracking</td><td align='center'><b>$config{PT_USERPROC}</b></td><td align='center'>0</td><td align='center'>15</td><td align='center'>8</td></tr>\n";
	print "<tr bgcolor='#F4F4EA'><td>Enable User Process Tracking for all system accounts</td><td align='center'><b>$config{PT_ALL_USERS}</b></td><td align='center'>0</td><td align='center'>1</td><td align='center'>1</td></tr>\n";
	print "<tr bgcolor='#FFFFFF'><td>Skip Apache Process Tracking</td><td align='center'><b>$config{PT_SKIP_HTTP}</b></td><td align='center'>1</td><td align='center'>1</td><td align='center'>0</td></tr>\n";
	print "<tr bgcolor='#F4F4EA'><td>Ignore IPs in /etc/relayhosts (cPanel only)</td><td align='center'><b>$config{RELAYHOSTS}</b></td><td align='center'>1</td><td align='center'>0</td><td align='center'>0</td></tr>\n";
	print "<tr bgcolor='#FFFFFF'><td>Port Scan protection</td><td align='center'><b>$config{PS_LIMIT}</b></td><td align='center'>20</td><td align='center'>10</td><td align='center'>5</td></tr>\n";
	print "<tr bgcolor='#F4F4EA'><td>Temporary to Permanent IP blocking</td><td align='center'><b>$config{LF_PERMBLOCK}</b></td><td align='center'>0</td><td align='center'>0</td><td align='center'>1</td></tr>\n";
	print "<tr bgcolor='#FFFFFF'><td>Permanently block IPs by network class</td><td align='center'><b>$config{LF_NETBLOCK}</b></td><td align='center'>0</td><td align='center'>0</td><td align='center'>1</td></tr>\n";
	print "<tr bgcolor='#F4F4EA'><td>System Integrity Checking (md5sum checks)</td><td align='center'><b>$config{LF_INTEGRITY}</b></td><td align='center'>0</td><td align='center'>3600</td><td align='center'>3600</td></tr>\n";
	print "<tr bgcolor='#FFFFFF'><td colspan='2'><b>Select quick firewall protection level</b></td><td align='center'><input name='quickselect' type='submit' value='Low'></td><td align='center'><input name='quickselect' type='submit' value='Medium'></td><td align='center'><input name='quickselect' type='submit' value='High'></td></tr>\n";
	print "</table></td></tr></table></form>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "quicksave") {
	my %newconf;
	if ($FORM{quickselect} eq "Low") {
		$newconf{SMTP_BLOCK} = "0";
		$newconf{SMTP_ALLOWLOCAL} = "1";
		$newconf{LF_DSHIELD} = "0";
		$newconf{LF_SPAMHAUS} = "0";
		$newconf{CT_LIMIT} = "0";
		$newconf{CT_PERMANENT} = "0";
		$newconf{PT_SKIP_HTTP} = "1";
		$newconf{PT_LIMIT} = "60";
		$newconf{PT_USERPROC} = "0";
		$newconf{PT_ALL_USERS} = "0";
		$newconf{LF_DIRWATCH_DISABLE} = "0";
		$newconf{LF_DIRWATCH} = "300";
		$newconf{RELAYHOSTS} = "1";
		$newconf{SYNFLOOD} = "0";
		$newconf{PS_INTERVAL} = "0";
		$newconf{PS_LIMIT} = "10";
		$newconf{LF_PERMBLOCK} = "0";
		$newconf{LF_NETBLOCK} = "0";
		$newconf{LF_INTEGRITY} = "0";
	}
	if ($FORM{quickselect} eq "Medium") {
		$newconf{SMTP_BLOCK} = "1";
		$newconf{SMTP_ALLOWLOCAL} = "1";
		$newconf{LF_DSHIELD} = "86400";
		$newconf{LF_SPAMHAUS} = "86400";
		$newconf{CT_LIMIT} = "400";
		$newconf{CT_PERMANENT} = "0";
		$newconf{PT_SKIP_HTTP} = "1";
		$newconf{PT_LIMIT} = "60";
		$newconf{PT_USERPROC} = "15";
		$newconf{PT_ALL_USERS} = "1";
		$newconf{LF_DIRWATCH_DISABLE} = "1";
		$newconf{LF_DIRWATCH} = "120";
		$newconf{RELAYHOSTS} = "0";
		$newconf{SYNFLOOD} = "0";
		$newconf{PS_INTERVAL} = "300";
		$newconf{PS_LIMIT} = "10";
		$newconf{DROP_LOGGING} = "1";
		$newconf{LF_PERMBLOCK} = "0";
		$newconf{LF_NETBLOCK} = "0";
		$newconf{LF_INTEGRITY} = "3600";
	}
	if ($FORM{quickselect} eq "High") {
		$newconf{SMTP_BLOCK} = "1";
		$newconf{SMTP_ALLOWLOCAL} = "0";
		$newconf{LF_DSHIELD} = "86400";
		$newconf{LF_SPAMHAUS} = "86400";
		$newconf{CT_LIMIT} = "300";
		$newconf{CT_PERMANENT} = "1";
		$newconf{PT_SKIP_HTTP} = "0";
		$newconf{PT_LIMIT} = "30";
		$newconf{PT_USERPROC} = "8";
		$newconf{PT_ALL_USERS} = "1";
		$newconf{LF_DIRWATCH_DISABLE} = "1";
		$newconf{LF_DIRWATCH} = "60";
		$newconf{RELAYHOSTS} = "0";
		$newconf{SYNFLOOD} = "1";
		$newconf{PS_INTERVAL} = "300";
		$newconf{PS_LIMIT} = "5";
		$newconf{DROP_LOGGING} = "1";
		$newconf{LF_PERMBLOCK} = "1";
		$newconf{LF_NETBLOCK} = "1";
		$newconf{LF_INTEGRITY} = "3600";
	}
	
	sysopen (IN, "/etc/csf/csf.conf", O_RDWR | O_CREAT);
	flock (IN, LOCK_SH);
	my @confdata = <IN>;
	close (IN);
	chomp @confdata;

	sysopen (OUT, "/etc/csf/csf.conf", O_WRONLY | O_CREAT);
	flock (OUT, LOCK_EX);
	seek (OUT, 0, 0);
	truncate (OUT, 0);
	for (my $x = 0; $x < @confdata;$x++) {
		if (($confdata[$x] !~ /^\#/) and ($confdata[$x] =~ /=/)) {
			my ($start,$end) = split (/\s=\s/,$confdata[$x]);
			my $name = $start;
			if (defined $newconf{$name}) {
				print OUT "$name = \"$newconf{$name}\"\n";
			} else {
				print OUT "$confdata[$x]\n";
			}
		} else {
			print OUT "$confdata[$x]\n";
		}
	}
	close (OUT);

	print "<p>$FORM{quickselect} security level settings saved. You should restart both csf and lfd.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='action' value='restartboth'><input type='submit' value='Restart csf+lfd'></form></p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "upgrade") {
	if ($config{DIRECTADMIN}) {
		print "<p>Due to restrictions in DirectAdmin you must login to the root shell to upgrade csf using:\n<p><b>csf -u</b>\n";
	} else {
		print "<p>Upgrading csf...</p>\n<p><pre style='font-family: Courier New, Courier; font-size: 12px'>\n";
		&printcmd("perl /etc/csf/csf.pl -u");
		print "</p>\n<p>...<b>Done</b>.</p>\n";

		open (IN, "</etc/csf/version.txt") or die $!;
		$myv = <IN>;
		close (IN);
		chomp $myv;
	}

	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "denyf") {
	print "<p>Removing all entries from csf.deny...</p>\n<p><pre style='font-family: Courier New, Courier; font-size: 12px'>\n";
	&printcmd("perl /etc/csf/csf.pl -df");
	&printcmd("perl /etc/csf/csf.pl -tf");
	print "</p>\n<p>...<b>Done</b>.</p>\n";

	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "csftest") {
	print "<p>Testing iptables...</p>\n<p><pre style='font-family: Courier New, Courier; font-size: 12px'>\n";
	&printcmd("perl /etc/csf/csftest.pl");
	print "</p>\n<p>...<b>Done</b>.</p>\n";
	print "<p>You should restart csf after having run this test.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='action' value='restart'><input type='submit' value='Restart csf'></form></p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
elsif ($FORM{mobi}) {
	print "<table align='center' border='0' width='95%' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
	print "<tr bgcolor='#FFFFFF'><form action='$script' method='post'><td><input type='hidden' name='mobi' value='$FORM{mobi}'><input type='hidden' name='action' value='qallow'><input type='submit' value='Quick Allow'></td><td width='100%'><input name='ip' value='' size='18' style='background-color: lightgreen'></td></form></tr>\n";
	print "<tr bgcolor='#F4F4EA'><form action='$script' method='post'><td><input type='hidden' name='mobi' value='$FORM{mobi}'><input type='hidden' name='action' value='qdeny'><input type='submit' value='Quick Deny'></td><td width='100%'><input name='ip' value='' size='18' style='background-color: pink'></td></form></tr>\n";
	print "<tr bgcolor='#FFFFFF'><form action='$script' method='post'><td><input type='hidden' name='mobi' value='$FORM{mobi}'><input type='hidden' name='action' value='kill'><input type='submit' value='Remove Deny'></td><td width='100%'><input name='ip' value='' size='18'></td></form></tr>\n";
	print "</table>\n";
}
else {
	my ($childin, $childout);
	my $pid = open3($childin, $childout, $childout, "$config{IPTABLES} -L LOCALINPUT -n");
	my @iptstatus = <$childout>;
	waitpid ($pid, 0);
	chomp @iptstatus;
	$status = "Enabled and Running";

	if (-e "/etc/csf/csf.disable") {
		$status = "<b><font color='red'>Disabled and Stopped</font></b> <input type='hidden' name='action' value='enable'><input type='submit' value='Enable'>"
	}
	elsif ($config{TESTING}) {
		$status = "<b><font color='red'>Enabled but in Test Mode</font></b> - Don't forget to disable TESTING in the Firewall Configuration";
	}
	elsif ($iptstatus[0] !~ /^Chain LOCALINPUT/) {
		$status = "<b><font color='red'>Enabled but Stopped</font></b> <input type='hidden' name='action' value='start'><input type='submit' value='Start'>"
	}
	if (-e "/etc/csf/lfd.restart") {$status .= " (lfd restart request pending)"}

	my $tempcnt = 0;
	if (! -z "/etc/csf/csf.tempban") {
		sysopen (IN, "/etc/csf/csf.tempban", O_RDWR);
		flock (IN, LOCK_EX);
		my @data = <IN>;
		close (IN);
		$tempcnt = scalar @data;
	}
	my $tempbans = "(Currently: $tempcnt temp IP bans)";

	my $permcnt = 0;
	if (! -z "/etc/csf/csf.deny") {
		sysopen (IN, "/etc/csf/csf.deny", O_RDWR);
		flock (IN, LOCK_SH);
		while (my $line = <IN>) {
			if ($line =~ /^(\#|\n|\r)/) {next}
			$permcnt++;
		}
		close (IN);
	}
	my $permbans = "(Currently: $permcnt permanent IP bans)";

	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
	print "<tr><form action='$script' method='post'><th align='center' colspan='2'>Firewall Status: $status</th></form></tr></table><br>\n";

	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
	print "<tr><th align='left' colspan='2'>Server Security Information</th></tr>";
	print "<tr bgcolor='#F4F4EA'><form action='$script' method='post'><td><input type='hidden' name='action' value='servercheck'><input type='submit' value='Check Server Security'></td><td width='100%'>Perform a basic security, stability and settings check on the server</td></form></tr>\n";
	print "<tr bgcolor='#FFFFFF'><form action='$script' method='post'><td><input type='hidden' name='action' value='readme'><input type='submit' value='Firewall Information'></td><td width='100%'>View the csf+lfd readme.txt file</td></form></tr>\n";
	print "<tr bgcolor='#F4F4EA'><form action='$script' method='post'><td><input type='hidden' name='action' value='status'><input type='submit' value='View iptables Rules'></td><td width='100%'>Display the active iptables rules</td></form></tr>\n";
	print "<tr bgcolor='#FFFFFF'><form action='$script' method='post'><td><input type='hidden' name='action' value='tail'><input type='submit' value='View lfd Log'></td><td width='100%'>View the last <input type='text' name='lines' value='30' size='5'> lines of the Login Failure Daemon (lfd) log file and <input type='checkbox' name='refresh' value='1'> auto-refresh the log view</td></form></tr>\n";
	if ($config{ST_ENABLE}) {
		print "<tr bgcolor='#F4F4EA'><form action='$script' method='post'><td><input type='hidden' name='action' value='viewlogs'><input type='submit' value='View iptables Log'></td><td width='100%'>View the last $config{ST_IPTABLES} iptables log lines</td></form></tr>\n";
	}
	print "</table><br>\n";

	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
	my ($status, $text) = &urlget("http://www.configserver.com/free/csf/version.txt");
	my $actv = $text;
	my $up = 0;

	print "<tr bgcolor='#FFFFFF'><th align='left' colspan='2'>Upgrade</th></tr>";
	if ($actv ne "") {
		if ($actv =~ /^[\d\.]*$/) {
			if ($actv > $myv) {
				print "<tr bgcolor='#F4F4EA'><form action='$script' method='post'><td><input type='hidden' name='action' value='upgrade'><input type='submit' value='Upgrade csf'></td><td width='100%'><b>A new version of csf (v$actv) is available. Upgrading will retain your settings<br><a href='http://www.configserver.com/free/csf/changelog.txt' target='_blank'>View ChangeLog</a></b></td></form></tr>\n";
			} else {
				print "<tr bgcolor='#F4F4EA'><td colspan='2'>You appear to be running the latest version of csf. An Upgrade button will appear here if a new version becomes available</td></tr>\n";
			}
			$up = 1;
		}
	}
	unless ($up) {
		print "<tr bgcolor='#F4F4EA'><td colspan='2'>Failed to determine the latest version of csf. An Upgrade button will appear here if new version is detected</td></tr>\n";
	}
	if (-e "/etc/apf" or -e "/usr/local/bfd") {
		print "<tr bgcolor='#FFFFFF'><form action='$script' method='post'><td><input type='hidden' name='action' value='remapf'><input type='submit' value='Remove APF/BFD'></td><td width='100%'>Remove APF/BFD from the server. You must not run both APF or BFD with csf on the same server</td></form></tr>\n";
	}
	print "</table><br>\n";

	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
	print "<tr><th align='left' colspan='2'>csf - ConfigServer Firewall</th></tr>";
	print "<tr bgcolor='#F4F4EA'><form action='$script' method='post'><td><input type='hidden' name='action' value='quick'><input type='submit' value='Firewall Security Level'></td><td width='100%'>Pre-configured settings for Low, Medium or High firewall security</td></form></tr>\n";
	print "<tr bgcolor='#FFFFFF'><form action='$script' method='post'><td><input type='hidden' name='action' value='conf'><input type='submit' value='Firewall Configuration'></td><td width='100%'>Edit the configuration file for the csf firewall and lfd</td></form></tr>\n";
	print "<tr bgcolor='#F4F4EA'><form action='$script' method='post'><td><input type='hidden' name='action' value='qallow'><input type='submit' value='Quick Allow'></td><td width='100%'>Allow IP address <input name='ip' value='' size='18' style='background-color: lightgreen'> through the firewall and add to the allow file (csf.allow)</td></form></tr>\n";
	print "<tr bgcolor='#FFFFFF'><form action='$script' method='post'><td><input type='hidden' name='action' value='qdeny'><input type='submit' value='Quick Deny'></td><td width='100%'>Block IP address <input name='ip' value='' size='18' style='background-color: pink'> in the firewall and add to the deny file (csf.deny)</td></form></tr>\n";
	print "<tr bgcolor='#F4F4EA'><form action='$script' method='post'><td><input type='hidden' name='action' value='allow'><input type='submit' value='Firewall Allow IPs'></td><td width='100%'>Edit csf.allow, the IP address allow file</td></form></tr>\n";
	print "<tr bgcolor='#FFFFFF'><form action='$script' method='post'><td><input type='hidden' name='action' value='deny'><input type='submit' value='Firewall Deny IPs'></td><td width='100%'>Edit csf.deny, the IP address deny file $permbans</td></form></tr>\n";
	print "<tr bgcolor='#F4F4EA'><form action='$script' method='post'><td><input type='hidden' name='action' value='enable'><input type='submit' value='Firewall Enable'></td><td width='100%'>Enables csf and lfd if previously Disabled</td></form></tr>\n";
	print "<tr bgcolor='#FFFFFF'><form action='$script' method='post'><td><input type='hidden' name='action' value='disable'><input type='submit' value='Firewall Disable'></td><td width='100%'>Completely disables csf and lfd</td></form></tr>\n";
#	print "<tr bgcolor='#FFFFFF'><form action='$script' method='post'><td><input type='hidden' name='action' value='start'><input type='submit' value='Firewall Start'></td><td width='100%'>Start the csf iptables firewall</td></form></tr>\n";
	print "<tr bgcolor='#F4F4EA'><form action='$script' method='post'><td><input type='hidden' name='action' value='restart'><input type='submit' value='Firewall Restart'></td><td width='100%'>Restart the csf iptables firewall</td></form></tr>\n";
#	print "<tr bgcolor='#FFFFFF'><form action='$script' method='post'><td><input type='hidden' name='action' value='stop'><input type='submit' value='Firewall Stop'></td><td width='100%'>Stop the iptables firewall</td></form></tr>\n";
	print "<tr bgcolor='#FFFFFF'><form action='$script' method='post'><td><input type='hidden' name='action' value='kill'><input type='submit' value='Remove Deny'></td><td width='100%'>Remove IP address <input name='ip' value='' size='18'> from the deny file (csf.deny) and unblock from the firewall</td></form></tr>\n";
	print "<tr bgcolor='#F4F4EA'><form action='$script' method='post'><td><input type='hidden' name='action' value='tempdeny'><input type='submit' value='Temporary Deny'></td><td width='100%'>Temporarily block IP address <input name='ip' value='' size='18'> for <input name='timeout' value='' size='6'> seconds</td></form></tr>\n";
	print "<tr bgcolor='#FFFFFF'><form action='$script' method='post'><td><input type='hidden' name='action' value='temp'><input type='submit' value='Temporary IP Bans'></td><td width='100%'>View/Unblock the <i>temporary</i> IP bans $tempbans</td></form></tr>\n";
	print "<tr bgcolor='#F4F4EA'><form action='$script' method='post'><td><input type='hidden' name='action' value='grep'><input type='submit' value='Search for IP'></td><td width='100%'>Search iptables for IP address <input name='ip' value='' size='18'></td></form></tr>\n";
	print "<tr bgcolor='#FFFFFF'><form action='$script' method='post'><td><input type='hidden' name='action' value='sips'><input type='submit' value='Deny Server IPs'></td><td width='100%'>Deny access to and from specific IP addresses configured on the server (csf.sips)</td></form></tr>\n";
	print "<tr bgcolor='#F4F4EA'><form action='$script' method='post'><td><input type='hidden' name='action' value='denyf'><input type='submit' value='Flush all Blocks'></td><td width='100%'>Removes and unblocks all entries in csf.deny (excluding those marked \"do not delete\") and all temporary IP bans</td></form></tr>\n";
	print "</table><br>\n";

	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
	print "<tr><th align='left' colspan='2'>lfd - Login Failure Daemon</th></tr>";
	print "<tr bgcolor='#F4F4EA'><form action='$script' method='post'><td><input type='hidden' name='action' value='lfdstatus'><input type='submit' value='lfd Status'></td><td width='100%'>Display lfd status</td></form></tr>\n";
	print "<tr bgcolor='#FFFFFF'><form action='$script' method='post'><td><input type='hidden' name='action' value='lfdrestart'><input type='submit' value='lfd Restart'></td><td width='100%'>Restart lfd</td></form></tr>\n";
#	unless ($config{DIRECTADMIN}) {
#		print "<tr bgcolor='#FFFFFF'><form action='$script' method='post'><td><input type='hidden' name='action' value='lfdstart'><input type='submit' value='lfd Start'></td><td width='100%'>Start lfd</td></form></tr>\n";
#		print "<tr bgcolor='#F4F4EA'><form action='$script' method='post'><td><input type='hidden' name='action' value='lfdstop'><input type='submit' value='lfd Stop'></td><td width='100%'>Stop lfd</td></form></tr>\n";
#	}
	print "<tr bgcolor='#F4F4EA'><form action='$script' method='post'><td nowrap><input type='hidden' name='action' value='ignorefiles'><select name='ignorefile'>\n";
	print "<option value='csf.ignore'>csf.ignore - IP Blocking</option>\n";
	print "<option value='csf.pignore'>csf.pignore, Process Tracking</option>\n";
	print "<option value='csf.fignore'>csf.fignore, Directory Watching</option>\n";
	print "<option value='csf.signore'>csf.signore, Script Alert</option>\n";
	print "<option value='csf.rignore'>csf.rignore, Reverse DNS lookup</option>\n";
	print "<option value='csf.suignore'>csf.suignore, Superuser check</option>\n";
	print "<option value='csf.mignore'>csf.mignore, RT_LOCALRELAY</option>\n";
	print "</select> <input type='submit' value='Edit'></td><td width='100%'>Edit lfd ignore file</td></form></tr>\n";
	print "<tr bgcolor='#FFFFFF'><form action='$script' method='post'><td><input type='hidden' name='action' value='dirwatch'><input type='submit' value='lfd Directory File Watching'></td><td width='100%'>Edit the Directory File Watching file (csf.dirwatch) - all listed files and directories will be watched for changes by lfd</td></form></tr>\n";
	print "<tr bgcolor='#F4F4EA'><form action='$script' method='post'><td><input type='hidden' name='action' value='dyndns'><input type='submit' value='lfd Dynamic DNS'></td><td width='100%'>Edit the Dynamic DNS file (csf.dyndns) - all listed domains will be resolved and allowed through the firewall</td></form></tr>\n";
	print "<tr bgcolor='#FFFFFF'><form action='$script' method='post'><td><input type='hidden' name='action' value='templates'><select name='template'>\n";
	foreach my $tmp ("alert.txt","tracking.txt","connectiontracking.txt","processtracking.txt","accounttracking.txt","usertracking.txt","sshalert.txt","sualert.txt","cpanelalert.txt","scriptalert.txt","filealert.txt","watchalert.txt","loadalert.txt","resalert.txt","integrityalert.txt","exploitalert.txt","relayalert.txt","portscan.txt","permblock.txt","netblock.txt","queuealert.txt","logfloodalert.txt") {print "<option>$tmp</option>\n"}
	print "</select> <input type='submit' value='Edit'></td><td width='100%'>Edit email alert templates. See Firewall Information for details of each file</td></form></tr>\n";
	print "</table><br>\n";

	if ((-e "/usr/local/apache/logs/audit_log") or (-e "/usr/local/apache/logs/modsec_audit.log") and ($script ne "addon_csf.cgi")) {
		print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
		print "<tr><th align='left' colspan='2'>mod_security</th></tr>";
		print "<tr bgcolor='#F4F4EA'><form action='$script' method='post'><td><input type='hidden' name='action' value='ms_list'><input type='submit' value='mod_security log'></td><td width='100%'>View the last <input type='text' name='lines' value='10' size='3'> entries in the mod_security log file<br>Note: If your audit_log file is very large it may take some time to process it</td></form></tr>\n";
		my @modsecfiles;
		my @modsecdirfiles;
		opendir (DIR, "/usr/local/apache/conf/");
		while (my $file = readdir (DIR)) {
			if ($file =~ /^(mod_sec|modsec).*\.conf$/i) {
				push @modsecfiles, $file;
			}
			if (-d "/usr/local/apache/conf/$file" and ($file =~ /^(mod_sec|modsec)/i)) {
				opendir (MODDIR, "/usr/local/apache/conf/$file");
				while (my $modfile = readdir (MODDIR)) {
					if ($modfile =~ /^\.|\.\.$/) {next}
					push @modsecdirfiles, "$file/$modfile";
				}
				closedir (MODDIR);
			}
		}
		closedir (DIR);
		@modsecfiles = sort @modsecfiles;
		@modsecdirfiles = sort @modsecdirfiles;
		if (@modsecfiles) {
			print "<tr bgcolor='#FFFFFF'><form action='$script' method='post'><td><input type='hidden' name='action' value='ms_config'><select name='template'>\n";
			foreach my $file (@modsecfiles,@modsecdirfiles) {print "<option>$file</option>\n"}
			print "</select> <input type='submit' value='Edit'></td><td width='100%'>Edit files containing mod_security configuration settings in /usr/local/apache/conf/<br>Note: Files or directories must be prefixed modsec* or mod_sec* to be detected</td></form></tr>\n";
		}
		print "</table><br>\n";
	}

	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
	print "<tr bgcolor='#FFFFFF'><th align='left' colspan='2'>Extra</th></tr>";
	print "<tr bgcolor='#F4F4EA'><form action='$script' method='post'><td><input type='hidden' name='action' value='csftest'><input type='submit' value='Test iptables'></td><td width='100%'>Check that iptables has the required modules to run csf</td></form></tr>\n";
	print "</table>\n";
}

print "<pre style='font-family: Courier New, Courier; font-size: 12px'>csf: v$myv</pre>";
print "<p>&copy;2006-2010, <a href='http://www.configserver.com' target='_blank'>ConfigServer Services</a> (Way to the Web Limited)</p>\n";
# end main
###############################################################################
sub modsec {
	my @requests;
	my $start = 0;
	my $entry;
	my $log = "/usr/local/apache/logs/audit_log";
	if (-e "/usr/local/apache/logs/modsec_audit.log") {$log = "/usr/local/apache/logs/modsec_audit.log"}
	sysopen (IN, "$log", O_RDWR | O_CREAT);
	flock (IN, LOCK_SH);
	while (my $line = <IN>) {
		chomp $line;
		if ($line =~ /^\=\=(\w*)\=*$/) {
			$start = $1;
			$entry = "";
		}
		elsif ($line =~ /^\-\-(\w*)\-A\-\-$/) {
			$start = $1;
			$entry = "";
		}
		elsif ($line =~ /^\-\-$start\-\-$/ and $start) {
			push @requests, $entry;
			$start = 0;
			$entry = "";
		}
		elsif ($line =~ /^\-\-$start-Z\-\-$/ and $start) {
			push @requests, $entry;
			$start = 0;
			$entry = "";
		}
		elsif ($start) {
			$entry .= "$line\n";
		}
	}
	close (IN);

	if (@requests > 0) {
		my $start = 0;
		if ($FORM{lines} < @requests) {$start = @requests - $FORM{lines}}
		my $divcnt = 0;
		my $expcnt = @requests - $start;

		print "<style type='text/css'>\n<!--\n.submenu {\n    display:none;\n}\n.mhead {\n    display: block;\n}\n-->\n</style>\n$csfjs\n";
		print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
		print "<tr><th align='left' colspan='4'>ConfigServer ModSecurity Log Entries";
		print " <a href='javascript:expandO(\"expand\",$expcnt);'><img valign='absmiddle' src='$images/plus.png' name='i$divcnt' border='0' width='12' height='12'>Expand All</a>\n";
		print " <a href='javascript:expandO(\"collapse\",$expcnt);'><img valign='absmiddle' src='$images/minus.png' name='i$divcnt' border='0' width='12' height='12'>Collapse All</a>\n";
		print "</th></tr>\n";
		print "<tr bgcolor='#F4F4EA'><td>Domain</td><td>Source IP</td><td>Rule ID</td><td width='100%'>Date Stamp</td></tr>\n";
		for ($x = @requests -1; $x > $start - 1; $x--) {
			$divcnt++;
			$requests[$x] =~ s/\&/\&amp\;/g;
			$requests[$x] =~ s/>/\&gt\;/g;
			$requests[$x] =~ s/</\&lt\;/g;
			my @lines = split(/\n/,$requests[$x]);
			my @data = split(/\s/,$lines[0],8);
			my $span = "<a href='javascript:showMenu($divcnt);'><img valign='absmiddle' src='$images/plus.png' name='i$divcnt' border='0' width='12' height='12'></a>";

			my $host;
			my $id;
			if (my @ls = grep {$_ =~ /^Host: /} @lines) {
				if ($ls[0] =~ /^Host: (.*)$/) {$host = $1}
			}
			if ($host eq "") {$host = $data[5]}

			if (my @ls = grep {$_ =~ /\s\[id \"\d+\"\]\s/} @lines) {
				if ($ls[0] =~ /\s\[id \"(\d+)\"\]\s/) {$id = $1}
			}
			if ($id eq "") {$id = "unknown"}

			print "<tr bgcolor='#FFFFFF'><td style='border-top:1px solid #990000'><b>$host</b></td><td style='border-top:1px solid #990000'>$data[3]</td><td style='border-top:1px solid #990000' nowrap><b>$id</b></td><td style='border-top:1px solid #990000' nowrap>$data[0] $data[1] $span</td></tr>\n";

			my $entry = "<div class='submenu' id='s$divcnt'><p>\n";
			my $modsec = "";
			for (my $y = 0;$y < @lines;$y++) {
				if ($lines[$y] =~ /^mod_security-message: (.*)$/) {$modsec = $1}
				if ($lines[$y] =~ /^Message: (.*)$/) {$modsec = $1}
				$lines[$y] =~ s/^([\w\-\_]*):/<b>$1:<\/b>/;
				$entry .= &splitlines($lines[$y])."<br>\n";
				if ($y > 200) {
					$entry .= "... [truncated to 200 lines see audit_log for full entry] ...<br>\n";
					last;
				}
			}
			$entry .= "</p></div>\n";
			if ($modsec =~ /\w*\.\s(.*)$/) {$modsec = $1}
			$modsec = &splitlines($modsec);
			print "<tr bgcolor='#FFFFFF'><td colspan='4'>$modsec$entry</td></tr>\n";
		}
		print "</table>\n";
	} else {
		print "<p align='center'>No entries found in $log</p>\n";
	}
	print "<p align='center'><form action='$script' method='post'><input type='submit' value='Return'></form></p>\n";
}
###############################################################################
# start splitlines
sub splitlines {
	my $line = shift;
	my $cnt = 0;
	my $newline;
	for (my $x = 0;$x < length($line) ;$x++) {
		if ($cnt > 120) {
			$cnt = 0;
			$newline .= "<WBR>";
		}
		my $letter = substr($line,$x,1);
		if ($letter =~ /\s/) {
			$cnt = 0;
		} else {
			$cnt++;
		}
		$newline .= $letter;
	}

	return $newline;
}
# end splitlines
###############################################################################
# start printcmd
sub printcmd {
	my $cmd = shift;
	my ($childin, $childout);
	my $pid = open3($childin, $childout, $childout, $cmd);
	while (<$childout>) {print $_}
	waitpid ($pid, 0);
}
# end printcmd
###############################################################################
# loadconfig
sub loadconfig {
	sysopen (IN, "/etc/csf/csf.conf", O_RDWR | O_CREAT);
	flock (IN, LOCK_SH);
	my @config = <IN>;
	close (IN);
	chomp @config;

	foreach my $line (@config) {
		if ($line =~ /^\#/) {next}
		if ($line !~ /=/) {next}
		my ($name,$value) = split (/=/,$line);
		$name =~ s/\s//g;
		if ($value =~ /\"(.*)\"/) {
			$value = $1;
		} else {
			&error(__LINE__,"Invalid configuration line");
		}
		$config{$name} = $value;
	}
}
# end loadconfig
###############################################################################
# start sanity
sub sanity {
	my $sanity_item = shift;
	my $sanity_value = shift;

	$sanity_item =~ s/\s//g;
	$sanity_value =~ s/\s//g;
	unless (defined $sanity{TESTING}) {
		open (IN, "/etc/csf/sanity.txt");
		flock (IN, LOCK_SH);
		my @data = <IN>;
		close (IN);
		chomp @data;
		foreach my $line (@data) {
			my ($name,$value, $def) = split(/\=/,$line);
			$sanity{$name} = $value;
			$sanitydefault{$name} = $def;
		}
	}

	my $insane = 0;
	if (defined $sanity{$sanity_item}) {
		$insane = 1;
		foreach my $check (split(/\|/,$sanity{$sanity_item})) {
			if ($check =~ /-/) {
				my ($from,$to) = split(/\-/,$check);
				if (($sanity_value >= $from) and ($sanity_value <= $to)) {$insane = 0}

			} else {
				if ($sanity_value eq $check) {$insane = 0}
			}
		}
	}
	return ($insane,$sanity{$sanity_item},$sanitydefault{$sanity_item});
}
# end sanity
###############################################################################

###############################################################################
# start urlget (v1.3)
#
# Examples:
#my ($status, $text) = &urlget("http://prdownloads.sourceforge.net/clamav/clamav-0.92.tar.gz","/tmp/clam.tgz");
#if ($status) {print "Oops: $text\n"}
#
#my ($status, $text) = &urlget("http://www.configserver.com/free/msfeversion.txt");
#if ($status) {print "Oops: $text\n"} else {print "Version: $text\n"}
#
sub urlget {
	my $url = shift;
	my $file = shift;
	my $status = 0;
	my $timeout = 1200;

	use LWP::UserAgent;
	my $ua = LWP::UserAgent->new;
	$ua->timeout(30);
	my $req = HTTP::Request->new(GET => $url);
	my $res;
	my $text;

	($status, $text) = eval {
		local $SIG{__DIE__} = undef;
		local $SIG{'ALRM'} = sub {die "Download timeout after $timeout seconds"};
		alarm($timeout);
		if ($file) {
			$|=1;
			my $expected_length;
			my $bytes_received = 0;
			my $per = 0;
			my $oldper = 0;
			open (OUT, ">$file\.tmp") or return (1, "Unable to open $file\.tmp: $!");
			binmode (OUT);
			print "...0\%\n";
			$res = $ua->request($req,
				sub {
				my($chunk, $res) = @_;
				$bytes_received += length($chunk);
				unless (defined $expected_length) {$expected_length = $res->content_length || 0}
				if ($expected_length) {
					my $per = int(100 * $bytes_received / $expected_length);
					if ((int($per / 5) == $per / 5) and ($per != $oldper)) {
						print "...$per\%\n";
						$oldper = $per;
					}
				} else {
					print ".";
				}
				print OUT $chunk;
			});
			close (OUT);
			print "\n";
		} else {
			$res = $ua->request($req);
		}
		alarm(0);
		if ($res->is_success) {
			if ($file) {
				rename ("$file\.tmp","$file") or return (1, "Unable to rename $file\.tmp to $file: $!");
				return (0, $file);
			} else {
				return (0, $res->content);
			}
		} else {
			return (1, "Unable to download: ".$res->message);
		}
	};
	alarm(0);
	if ($@) {
		return (1, $@);
	}
	if ($text) {
		return ($status,$text);
	} else {
		return (1, "Download timeout after $timeout seconds");
	}
}
# end urlget
###############################################################################

1;
