#!/bin/sh
###############################################################################
# Copyright 2006-2010, Way to the Web Limited
# URL: http://www.configserver.com
# Email: sales@waytotheweb.com
###############################################################################

if [ -e "/usr/local/cpanel/version" ]; then
	echo "Running csf cPanel installer"
	echo
	sh install.cpanel.sh
	exit 0
elif [ -e "/usr/local/directadmin/directadmin" ]; then
	echo "Running csf DirectAdmin installer"
	echo
	sh install.directadmin.sh
	exit 0
fi

echo "Installing generic csf and lfd"
echo

echo "Check we're running as root"
if [ ! `id -u` = 0 ]; then
	echo
	echo "FAILED: You have to be logged in as root (UID:0) to install csf"
	exit
fi
echo

if [ ! -e "/etc/csf" ]; then
	mkdir -v /etc/csf
fi
if [ ! -e "/etc/csf/zone" ]; then
	mkdir -v /etc/csf/zone
fi
if [ ! -e "/etc/csf/stats" ]; then
	mkdir -v /etc/csf/stats
fi

if [ ! -e "/etc/csf/csf.conf" ]; then
	cp -avf csf.generic.conf /etc/csf/csf.conf
fi
if [ ! -e "/etc/csf/csf.allow" ]; then
	cp -avf csf.allow /etc/csf/.
fi
if [ ! -e "/etc/csf/csf.deny" ]; then
	cp -avf csf.deny /etc/csf/.
fi
if [ ! -e "/etc/csf/csf.dirwatch" ]; then
	cp -avf csf.dirwatch /etc/csf/.
fi
if [ ! -e "/etc/csf/csf.ignore" ]; then
	cp -avf csf.ignore /etc/csf/.
fi
if [ ! -e "/etc/csf/csf.pignore" ]; then
	cp -avf csf.generic.pignore /etc/csf/csf.pignore
fi
if [ ! -e "/etc/csf/csf.rignore" ]; then
	cp -avf csf.rignore /etc/csf/.
fi
if [ ! -e "/etc/csf/csf.fignore" ]; then
	cp -avf csf.fignore /etc/csf/.
fi
if [ ! -e "/etc/csf/csf.signore" ]; then
	cp -avf csf.signore /etc/csf/.
fi
if [ ! -e "/etc/csf/csf.suignore" ]; then
	cp -avf csf.suignore /etc/csf/.
fi
if [ ! -e "/etc/csf/csf.mignore" ]; then
	cp -avf csf.mignore /etc/csf/.
fi
if [ ! -e "/etc/csf/csf.sips" ]; then
	cp -avf csf.sips /etc/csf/.
fi
if [ ! -e "/etc/csf/csf.dyndns" ]; then
	cp -avf csf.dyndns /etc/csf/.
fi
if [ ! -e "/etc/csf/alert.txt" ]; then
	cp -avf alert.txt /etc/csf/.
else
	cp -avf alert.txt /etc/csf/alert.txt.new
fi
if [ ! -e "/etc/csf/logfloodalert.txt" ]; then
	cp -avf logfloodalert.txt /etc/csf/.
fi
if [ ! -e "/etc/csf/integrityalert.txt" ]; then
	cp -avf integrityalert.txt /etc/csf/.
fi
if [ ! -e "/etc/csf/exploitalert.txt" ]; then
	cp -avf exploitalert.txt /etc/csf/.
fi
if [ ! -e "/etc/csf/tracking.txt" ]; then
	cp -avf tracking.txt /etc/csf/.
fi
if [ ! -e "/etc/csf/connectiontracking.txt" ]; then
	cp -avf connectiontracking.txt /etc/csf/.
fi
if [ ! -e "/etc/csf/processtracking.txt" ]; then
	cp -avf processtracking.txt /etc/csf/.
fi
if [ ! -e "/etc/csf/accounttracking.txt" ]; then
	cp -avf accounttracking.txt /etc/csf/.
fi
if [ ! -e "/etc/csf/usertracking.txt" ]; then
	cp -avf usertracking.txt /etc/csf/.
fi
if [ ! -e "/etc/csf/sshalert.txt" ]; then
	cp -avf sshalert.txt /etc/csf/.
fi
if [ ! -e "/etc/csf/sualert.txt" ]; then
	cp -avf sualert.txt /etc/csf/.
fi
if [ ! -e "/etc/csf/scriptalert.txt" ]; then
	cp -avf scriptalert.txt /etc/csf/.
fi
if [ ! -e "/etc/csf/filealert.txt" ]; then
	cp -avf filealert.txt /etc/csf/.
fi
if [ ! -e "/etc/csf/watchalert.txt" ]; then
	cp -avf watchalert.txt /etc/csf/.
fi
if [ ! -e "/etc/csf/loadalert.txt" ]; then
	cp -avf loadalert.txt /etc/csf/.
else
	cp -avf loadalert.txt /etc/csf/loadalert.txt.new
fi
if [ ! -e "/etc/csf/resalert.txt" ]; then
	cp -avf resalert.txt /etc/csf/.
fi
if [ ! -e "/etc/csf/portscan.txt" ]; then
	cp -avf portscan.txt /etc/csf/.
else
	cp -avf portscan.txt /etc/csf/portscan.txt.new
fi
if [ ! -e "/etc/csf/permblock.txt" ]; then
	cp -avf permblock.txt /etc/csf/.
fi
if [ ! -e "/etc/csf/netblock.txt" ]; then
	cp -avf netblock.txt /etc/csf/.
fi
if [ ! -e "/etc/csf/messenger" ]; then
	cp -avf messenger /etc/csf/.
fi
if [ ! -e "/etc/csf/regex.custom.pm" ]; then
	cp -avf regex.custom.pm /etc/csf/.
fi
if [ ! -e "/etc/logrotate.d/lfd" ]; then
	cp -avf lfd.logrotate /etc/logrotate.d/lfd
fi
if [ ! -e "/etc/logrotate.d/lfd" ]; then
	cp -avf lfd.logrotate /etc/logrotate.d/lfd
fi
if [ ! -e "/etc/cron.d/csfcron.sh" ]; then
	cp -avf csfcron.sh /etc/cron.d/csfcron.sh
fi

cp -avf lfdcron.sh /etc/cron.d/lfdcron.sh
rm -f /etc/csf/csf.conf.*
cp -avf csf.pl /etc/csf/
cp -avf csfui.pl /etc/csf/
cp -avf csftest.pl /etc/csf/
cp -avf lfd.pl /etc/csf/
cp -avf regex.pm /etc/csf/
cp -avf servercheck.pm /etc/csf/
cp -avf readme.txt /etc/csf/
cp -avf sanity.txt /etc/csf/
cp -avf changelog.txt /etc/csf/
cp -avf install.txt /etc/csf/
cp -avf version.txt /etc/csf/
cp -avf license.txt /etc/csf/
cp -avf uninstall.generic.sh /etc/csf/uninstall.sh
cp -avf remove_apf_bfd.sh /etc/csf
cp -avf lfd.sh /etc/init.d/lfd
cp -avf csf.sh /etc/init.d/csf
cp -avf Net /etc/csf/
cp -avf Sys /etc/csf/
cp -avf File /etc/csf/
cp -avf IP /etc/csf/
chmod -R 600 /etc/csf
chmod 600 /var/log/lfd.log*

chmod -v 700 /etc/csf/uninstall.sh
chmod -v 700 /etc/csf/csf.pl
chmod -v 700 /etc/csf/csfui.pl
chmod -v 700 /etc/csf/csftest.pl
chmod -v 700 /etc/csf/servercheck.pm
chmod -v 700 /etc/csf/lfd.pl
chmod -v 700 /etc/init.d/lfd
chmod -v 700 /etc/init.d/csf
chmod -v 644 /etc/cron.d/lfdcron.sh
chmod -v 644 /etc/cron.d/csfcron.sh

ln -sv /etc/csf/csf.pl /usr/sbin/csf
ln -sv /etc/csf/lfd.pl /usr/sbin/lfd

chown -R root:root /etc/csf /etc/init.d/lfd /etc/init.d/csf /usr/sbin/csf /usr/sbin/lfd

perl auto.generic.pl install

if [ -f /etc/debian_version ] || [ -f /etc/lsb-release ]; then
	update-rc.d lfd defaults
	update-rc.d csf defaults
elif [ -f /etc/gentoo-release ]; then
	rc-update add lfd default
	rc-update add csf default
elif [ -f /etc/slackware-version ]; then
	ln -sv /etc/init.d/csf /etc/rc.d/rc3.d/S80csf
	ln -sv /etc/init.d/csf /etc/rc.d/rc4.d/S80csf
	ln -sv /etc/init.d/csf /etc/rc.d/rc5.d/S80csf
	ln -sv /etc/init.d/lfd /etc/rc.d/rc3.d/S85lfd
	ln -sv /etc/init.d/lfd /etc/rc.d/rc4.d/S85lfd
	ln -sv /etc/init.d/lfd /etc/rc.d/rc5.d/S85lfd
else
	/sbin/chkconfig lfd on
	/sbin/chkconfig csf on
fi

cd webmin ; tar -czf /etc/csf/csfwebmin.tgz ./*

echo
echo "Installation Completed"
echo
