#!/bin/sh
#
###############################################################################
# lfd
#
# Written by Jonathan Michaelson <jonathan@waytotheweb.com>
# A daemon that provides a method to track generic POP3 or IMAP logins and then
# email (in future:also block) the user if they exceed the number of accesses
# per given minutes allowed.
#
# Copyright 2006-2010 Way to the Web Limited (http://www.configserver.com)
###############################################################################
#
# chkconfig: 2345 80 30
# description: Login Failure Daemon

[ -f /usr/sbin/lfd ] || exit 0

# Source function library.
if [ -f /etc/init.d/functions ]; then
	. /etc/init.d/functions
fi

PID=/var/run/lfd.pid
DAEMON=/usr/sbin/lfd
PIDOF=pidof

if [ -f /etc/SuSE-release ]; then
	. /etc/rc.status
	rc_reset
fi

# See how we were called.
case "$1" in
  start)
	echo -n "Starting lfd:"
	$DAEMON
	if [ -f /etc/SuSE-release ]; then
		rc_status -v
	elif [ -f /etc/debian_version ] || [ -f /etc/lsb-release ] || [ -f /etc/gentoo-release ]; then
		echo " Done"
	else
		success
		echo
	fi
	;;
  stop)
	echo -n "Stopping lfd:"
	if [ -f /etc/SuSE-release ]; then
		killproc lfd
		rc_status -v
	elif [ -f /etc/debian_version ] || [ -f /etc/lsb-release ] || [ -f /etc/gentoo-release ]; then
		kill `$PIDOF lfd`
		echo " Done"
	else
		killproc lfd
		success
		echo
	fi
	;;
  status)
        echo -n "Status of lfd:"
	if [ -f /etc/SuSE-release ]; then
	        checkproc lfd
	        rc_status -v
	elif [ -f /etc/debian_version ] || [ -f /etc/lsb-release ] || [ -f /etc/gentoo-release ]; then
		if [ -n "`$PIDOF lfd`" ]; then
			echo " Running"
		else
			echo " Stopped"
		fi
	else
		status lfd
		echo
	fi
        ;;
  restart)
	$0 stop
	$0 start
	;;
  *)
	echo "Usage: /etc/init.d/lfd start|stop|restart|status"
	exit 1
esac

exit 0
